%=====================================================================
%
%   These are the codes used to generate Figure 3 in 
%   "Information Quality, Disagreement and Political Polarisation"
%   Version: 17th May 2024
%
%   By R. Emre Aytimur and Richard M. H. Suen
%
%=====================================================================

close all; 
clear all; 

phi   = 1;
gamma = 3; 

sigma_min = gamma/phi/2/sqrt(2*pi);

% 3 combinations of tau_s and tau_s_hat
A = [0.06 0.6; 0.06 0.20; 0.06 0.06]; 

n1 = 3; 
n2 = 1000;

sigma_tilda = -999*ones(n1,n2); 

x_eq = -999*ones(n1,n2);

EU_Diff = -999*ones(n1,n2);

cutoff2 = -999*ones(n1, n2); 

%====================================================================
% Case 1: tau_s_hat >> tau_s

tau_s     = A(1,1);
tau_s_hat = A(1,2);

cutoff = tau_s*tau_s_hat/(tau_s_hat - 2*tau_s); 

%tau_e = linspace(0.1*cutoff, 2*cutoff, n2); 

tau_e = linspace(0.08, 2.58, n2);

psi = tau_e./(tau_s + tau_e);

var = 1./tau_e + 1/tau_s;

cutoff2(1,:) = sqrt(2/pi)*psi.*sqrt(var); 

var_p = 1./tau_e + 1/tau_s_hat;

sigma_tilda(1,:) = psi.*sqrt(var_p);

diff = sigma_tilda(1,:) - sigma_min;

x = diff.*gt(diff, 0);

x_eq(1,:) = 2*sqrt(2*pi)*phi*x./(4*phi + 2*sqrt(2*pi)*sigma_tilda(1,:));

EU_Diff(1,:) = ( (4/sqrt(2*pi))*(psi.*sqrt(var)) - x_eq(1,:) ).*x_eq(1,:);

%======================================================================
% Cases 2 & 3

for i = 2:n1

    tau_s2     = A(i,1);
    tau_s_hat2 = A(i,2);

    psi2 = tau_e./(tau_s2 + tau_e);

    var2 = 1./tau_e + 1/tau_s2;

    var_p2 = 1./tau_e + 1/tau_s_hat2;

    cutoff2(i,:) = sqrt(2/pi)*psi2.*sqrt(var2);

    sigma_tilda(i,:) = psi2.*sqrt(var_p2);

    diff2 = sigma_tilda(i,:) - sigma_min;

    x2 = diff2.*gt(diff2, 0);

    x_eq(i,:) = 2*sqrt(2*pi)*phi*x2./(4*phi + 2*sqrt(2*pi)*sigma_tilda(i,:));

    EU_Diff(i,:) = ( (4/sqrt(2*pi))*(psi2.*sqrt(var2)) - x_eq(i,:) ).*x_eq(i,:);

end

figure(1)
subplot(1,2,1)
plot(tau_e, sigma_tilda(1,:))
subplot(1,2,2)
plot(tau_e, EU_Diff(1,:))

figure(2)
subplot(1,2,1)
plot(tau_e, sigma_tilda(2,:), 'r')
subplot(1,2,2)
plot(tau_e, EU_Diff(2,:), 'r')

figure(3)
subplot(1,2,1)
plot(tau_e, sigma_tilda(3,:), 'g')
subplot(1,2,2)
plot(tau_e, EU_Diff(3,:), 'g')


figure(4)
subplot(3,1,1)
plot(tau_e, x_eq(1,:))
hold on
plot(tau_e, cutoff2(1,:), "b:")
hold off
subplot(3,1,2)
plot(tau_e, x_eq(2,:), 'r')
hold on
plot(tau_e, cutoff2(2,:), "b:")
hold off
subplot(3,1,3)
plot(tau_e, x_eq(3,:), 'g')
hold on
plot(tau_e, cutoff2(3,:), "b:")
hold off
